<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model 
{

    protected $table = 'campaigns';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function site()
    {
        return $this->belongsTo('Site');
    }

    public function eventTypes()
    {
        return $this->belongsToMany('CampaignEventType');
    }

}